# Generated Python Strategy for: PlayerB (meta)
# Run Index: 6
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run6_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for always_cooperate or always_defect
    if 'always_cooperate' in opponent_code or 'return "c"' in opponent_code or 'return c' in opponent_code:
        return "C"
    if 'always_defect' in opponent_code or 'return "d"' in opponent_code or 'return d' in opponent_code:
        return "D"
    
    # Check for tit-for-tat patterns
    tit_for_tat_patterns = [
        'opp_history[-1]',
        'opp_history[len(opp_history)-1]',
        'return opp_history[-1]',
        'return "d" if opp_history[-1] == "d" else "c"'
    ]
    if any(pattern in opponent_code for pattern in tit_for_tat_patterns):
        if not opp_history:
            return "C"
        return opp_history[-1]
    
    # Check for random behavior
    if 'random.choice' in opponent_code or 'random.randint' in opponent_code:
        return "D" if len(my_history) > 10 and sum(1 for m in opp_history if m == 'D') > len(opp_history) / 2 else "C"
    
    # Check for code length heuristic
    if len(opponent_program_code.splitlines()) < 5:
        return "C"
    
    # Check for self-referential patterns (potential meta-agent)
    if 'opponent_program_code' in opponent_code or 'PlayerB_DeepSeek' in opponent_code:
        return "C"
    
    # Default to cautious tit-for-tat with initial cooperation
    if not my_history:
        return "C"
    if len(my_history) >= 3 and all(m == 'D' for m in opp_history[-3:]):
        return "D"
    return opp_history[-1]